"""Web application server for testing the summarization API."""
from flask import Flask, render_template, request, jsonify
import requests

app = Flask(__name__)

# API endpoint
API_URL = "http://127.0.0.1:5000"


@app.route("/")
def index():
    """Serve the main page."""
    return render_template("index.html")


@app.route("/api/summarize", methods=["POST"])
def summarize_proxy():
    """Proxy to the summarization API."""
    try:
        data = request.get_json()
        response = requests.post(f"{API_URL}/summarize", json=data, timeout=60)
        return jsonify(response.json()), response.status_code
    except requests.exceptions.ConnectionError:
        return jsonify({"error": "API not available. Please start the API server first."}), 503
    except Exception:
        return jsonify({"error": "Request failed"}), 500


if __name__ == "__main__":
    print("Starting web application on http://127.0.0.1:8000")
    print("Make sure the API is running on http://127.0.0.1:5000")
    app.run(host="127.0.0.1", port=8000, debug=False)
